/*
 * Denna kod tillhr en tutorial utgiven p blinkenlight.se
 * (c) 2004 Petter Nordlander
 */

using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace csWebServer
{
	/// <summary>
	/// En Simpel WebServer
	/// </summary>
	public class server
	{
		private Socket m_Socket;
		private string m_Root;

		public server(Socket s, string loc)
		{
			m_Socket = s;
			m_Root = loc + "\\";
		}

		// Returnerar Mimetypen p en angiven ett angivet filnamn.
		private string GetMimetype(string file)
		{
			if( file.EndsWith(".htm") ||file.EndsWith(".html"))
				return "text/html";
			else if( file.EndsWith(".jpg") || file.EndsWith(".jpeg"))
				return "image/jpeg";
			else if( file.EndsWith(".gif"))
				return "image/gif";
			else if( file.EndsWith(".txt"))
				return "text/plain";
			else
				return "application/octet-stream";
		}

		// Skicka fanskapet till Weblsaren d
		private void SendToBrowser(byte[] data)
		{
			if( m_Socket.Connected )
			{
				if(m_Socket.Send(data,data.Length,0) == 1)
				{
					// Socket error
					Console.WriteLine("Kunde inte skicka data pga socketfel..");
				}
			}
		}

		// Skicka header
		private void SendHeader(string httpVersion,string mimetype,int totBytes,string statusCode)
		{
			string buffer;

			buffer = httpVersion + statusCode + "\r\n";
			buffer = buffer + "Server: HqspyServer\r\b";
			buffer = buffer + "Content-Type: " + mimetype + "\r\n";
			buffer = buffer + "AcceptRange: bytes\r\n";
			buffer = buffer + "Content-Length: " + totBytes + "\r\n\r\n";
			byte[] data = Encoding.ASCII.GetBytes(buffer); // Koda om strngen till bytedata
			SendToBrowser(data);
		}

		// Processa en request
		public void Process()
		{
			// ta emot requesten som weblsaren/klienten skickat.
			Byte[] receive = new Byte[1024];
			int i = m_Socket.Receive(receive,receive.Length,0);
			string buffer = Encoding.ASCII.GetString(receive);
	
			if( buffer.Substring(0,3) != "GET")
			{
				// Error! hanterar bara GET 
				Console.WriteLine("Fel - Hanterar bara GET frfrgningar");
				m_Socket.Close();
			}

			int startPos = buffer.IndexOf("HTTP",1);
			string httpVersion = buffer.Substring(startPos,8); // Tar ut http versionen
			string request = buffer.Substring(0, startPos -1); // Tar ut requesten
			request.Replace("\\","/"); // byter ut eventuella backslash mot frontslash
			
			// Om det inte r en fil med i adressen (index.htm motsv) och 
			// adressen inte slutar med '/' s antar vi att det r en katalog
			// som efterfrgas och lgger dit ett '/'
			if( (request.IndexOf(".")<1) && (!request.EndsWith("/")))
				request = request + "/";

			// Brja lsa in filnamnet. Den i slutet
			startPos = request.LastIndexOf("/") + 1;
			string reqFile = request.Substring(startPos);
			
			string dirname = request.Substring(request.IndexOf("/"),request.IndexOf("/")-3);
			if(reqFile.Length == 0)
				reqFile = "index.htm";

			string mimetype = this.GetMimetype(reqFile); // verstt frn filndrelse till mimetyp
			string filepath = m_Root + dirname + reqFile;
			Console.WriteLine("Skickar fil: " + reqFile);

			// Visa ett 404 fel om filen inte hittades. Ett mkt elegantare stt n detta r att 
			// helt enkelt stta filepath till ngon 404.html fil man sjlv skapat p servern
			// istllet fr att skicka hrdkodade strngar.
			if(File.Exists(filepath) == false)
			{
				string sError = "<h2>Error: 404, file does not exist</h2>";
				SendHeader(httpVersion,"",sError.Length," 404 Not Found");
				Byte[] data = Encoding.ASCII.GetBytes(sError);
				SendToBrowser(data);
				m_Socket.Close();
				return;
			}
			// Skicka ivg filen som efterfrgades
			else
			{
				FileStream fs = new FileStream(filepath,FileMode.Open,FileAccess.Read,FileShare.Read);
				BinaryReader br = new BinaryReader(fs);
				byte[] bytes = new byte[fs.Length];
				bytes = br.ReadBytes((int)fs.Length);
				int totBytes  = (int)fs.Length;
				br.Close();
				fs.Close();
				SendHeader(httpVersion,mimetype,totBytes," 200 OK");
				SendToBrowser(bytes);
				Console.WriteLine("Skickat: " + bytes.Length + " bytes\n");
			}
			m_Socket.Close(); // Stng ner socketen och kopplingen mot klienten.
		}
	}
}
