/*
 * Denna kod tillhr en tutorial utgiven p blinkenlight.se
 * (c) 2004 Petter Nordlander
 */
using System;
using System.Threading;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace csWebServer
{
	/// <summary>
	/// Ett consoleprogram som kontrollerar en webserver
	/// </summary>
	class Class1
	{
		[STAThread]
		static void Main(string[] args)
		{
			Class1 c = new Class1();
			Thread t = new Thread(new ThreadStart(c.RunServer));
			t.Start();
		}

		// Funktion som kr servern.
		private void RunServer()
		{	
			IPHostEntry ip = Dns.GetHostByName(Dns.GetHostName()); // Letar upp ipnumret
			IPEndPoint EP = new IPEndPoint(ip.AddressList[0],80); // Tar frsta ipnumret som hittades
			Socket s = new Socket(AddressFamily.InterNetwork,SocketType.Stream,ProtocolType.Tcp); // Skapa socket
			s.Bind(EP); // Bind EndPointen
			s.Listen(20); // Lyssna med backlog 20
			Console.WriteLine("Lyssnar..\n");
			
			//Lyssna och hantera kopplingar
			while(true)
			{
				Socket newSock = s.Accept(); // Fr en koppling frn en klient
				Console.WriteLine("Frfrgan frn: " + newSock.RemoteEndPoint + "...");
				server serv = new server(newSock,"c:\\webserver"); // Startar en Ny server..
				Thread t = new Thread(new ThreadStart( serv.Process)); // .. som en ny thread med socketen och..
				t.IsBackground = true;  // .. stller in lite threadegenskaper och..
				t.Priority = ThreadPriority.BelowNormal;
				t.Start(); // ...Kr!
			}
		}
	}
}
